package tv.twitch.social;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * The types of tokens that can be generated from a chat message.
 */
public enum SocialPresenceActivityType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_SOCIAL_ACTIVITY_TYPE_BROADCASTING(0),
    TTV_SOCIAL_ACTIVITY_TYPE_WATCHING(1),
    TTV_SOCIAL_ACTIVITY_TYPE_PLAYING(2),
    TTV_SOCIAL_ACTIVITY_TYPE_UNKNOWN(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, SocialPresenceActivityType> s_Map = new HashMap<Integer, SocialPresenceActivityType>();

    static {
        EnumSet<SocialPresenceActivityType> set = EnumSet.allOf(SocialPresenceActivityType.class);

        for (SocialPresenceActivityType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SocialPresenceActivityType lookupValue(int val) {
        SocialPresenceActivityType err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private SocialPresenceActivityType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
