package tv.twitch.social;

import java.util.*;

public enum SocialPresenceAvailabilityOverride {
    None(0),
    Offline(1),
    Away(2),
    Busy(3);

    private static Map<Integer, SocialPresenceAvailabilityOverride> s_Map =
        new HashMap<Integer, SocialPresenceAvailabilityOverride>();

    static {
        EnumSet<SocialPresenceAvailabilityOverride> set = EnumSet.allOf(SocialPresenceAvailabilityOverride.class);

        for (SocialPresenceAvailabilityOverride e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SocialPresenceAvailabilityOverride lookupValue(int val) {
        SocialPresenceAvailabilityOverride err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private SocialPresenceAvailabilityOverride(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
