package tv.twitch.social;

import java.util.*;

public enum SocialPresenceSessionAvailability {
    Offline(0),
    Online(1),
    Idle(2);

    private static Map<Integer, SocialPresenceSessionAvailability> s_Map =
        new HashMap<Integer, SocialPresenceSessionAvailability>();

    static {
        EnumSet<SocialPresenceSessionAvailability> set = EnumSet.allOf(SocialPresenceSessionAvailability.class);

        for (SocialPresenceSessionAvailability e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SocialPresenceSessionAvailability lookupValue(int val) {
        SocialPresenceSessionAvailability err = s_Map.get(val);

        if (err == null) {
            System.err.println("Enumeration value not found: " + val);
        }

        return err;
    }

    private int m_Value;

    private SocialPresenceSessionAvailability(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
