package tv.twitch.social;

import java.util.*;

public enum SocialPresenceUserAvailability {
    Offline(0),
    Online(1),
    Away(2),
    Busy(3);

    private static Map<Integer, SocialPresenceUserAvailability> s_Map =
        new HashMap<Integer, SocialPresenceUserAvailability>();

    static {
        EnumSet<SocialPresenceUserAvailability> set = EnumSet.allOf(SocialPresenceUserAvailability.class);

        for (SocialPresenceUserAvailability e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SocialPresenceUserAvailability lookupValue(int val) {
        SocialPresenceUserAvailability err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private SocialPresenceUserAvailability(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
