##########################################################################################################
#
# Fragment: social_java
#
# See README.md for fragment documentation.
#
##########################################################################################################

import glob
import os
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'social_java', os.path.dirname(os.path.realpath(__file__)))

    # Add source
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp'], 'Source Files/social/java')
    build_tools.add_source_files_recursively(fragment, 'tests/unit/source', ['.cpp'], 'Source Files/social/java/test')

    # Add headers
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/social', ['.h'], 'Header Files/social/java')
    build_tools.add_source_files_recursively(fragment, 'tests/unit/include/twitchsdk/social', ['.h'], 'Header Files/social/java/test')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'tests', 'unit', 'include') )

    # Export symbols
    fragment.add_symbol_export_files( os.path.join(fragment.root_path, 'source', 'exports.txt') )

    return fragment
