/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_nativelistener.h"
#include "twitchsdk/social/sociallistener.h"

namespace ttv {
using namespace ttv::social;

namespace binding {
namespace java {
class JavaSocialAPIListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaSocialAPIListenerProxy : public NativeModuleListener<ISocialAPIListener> {
 public:
  JavaSocialAPIListenerProxy(jobject jModule);

 public:
  virtual void SocialFriendInfoChanged(UserId userId, const std::vector<Friend>& changes) override;
  virtual void SocialFriendshipChanged(
    UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed) override;
  virtual void SocialRealtimeFriendRequestReceived(UserId userId, const FriendRequest& requestList) override;
  virtual void SocialUnreadFriendRequestCountChanged(UserId userId, uint32_t count) override;
  virtual void SocialFriendRequestRemoved(
    UserId userId, UserId otherUserId, FriendRequestRemovalReason reason) override;
  virtual void SocialPresenceSettingsChanged(UserId userId, const PresenceSettings& settings) override;
};
