/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/social/socialtypes.h"

namespace ttv {
using namespace ttv::social;

namespace binding {
namespace java {
/**
 * Loads all Java class information for the social module.
 */
void LoadAllSocialJavaClassInfo(JNIEnv* jEnv);

jobject GetJavaInstance_SocialPresenceActivity(JNIEnv* jEnv, const PresenceActivity& activity);
jobject GetJavaInstance_SocialPresence(JNIEnv* jEnv, const PresenceStatus& val);
jobject GetJavaInstance_SocialPresenceSettings(JNIEnv* jEnv, const PresenceSettings& val);
jobject GetJavaInstance_SocialFriend(JNIEnv* jEnv, const Friend& val);
jobject GetJavaInstance_SocialFriendArray(JNIEnv* jEnv, const std::vector<Friend>& list);
jobject GetJavaInstance_SocialFriendRequest(JNIEnv* jEnv, const FriendRequest& val);
jobject GetJavaInstance_SocialFriendRequestArray(JNIEnv* jEnv, const std::vector<FriendRequest>& list);

void GetNativeInstance_SocialPresenceSettings(JNIEnv* jEnv, jobject jSettings, PresenceSettings& settings);
void GetNativeInstance_SocialFeatureFlags(JNIEnv* jEnv, jobject jFeatures, FeatureFlags& features);
}  // namespace java
}  // namespace binding
}  // namespace ttv
