/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_isocialapilistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ISocialAPIListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/ISocialAPIListener");

        LookupJavaMethod(jEnv, info, "socialFriendInfoChanged", "(I[Ltv/twitch/social/SocialFriend;)V"); // public abstract void socialFriendInfoChanged(int, tv.twitch.social.SocialFriend[]);
        LookupJavaMethod(jEnv, info, "socialFriendshipChanged", "(I[Ltv/twitch/social/SocialFriend;[Ltv/twitch/social/SocialFriend;)V"); // public abstract void socialFriendshipChanged(int, tv.twitch.social.SocialFriend[], tv.twitch.social.SocialFriend[]);
        LookupJavaMethod(jEnv, info, "socialRealtimeFriendRequestReceived", "(ILtv/twitch/social/SocialFriendRequest;)V"); // public abstract void socialRealtimeFriendRequestReceived(int, tv.twitch.social.SocialFriendRequest);
        LookupJavaMethod(jEnv, info, "socialUnreadFriendRequestCountChanged", "(II)V"); // public abstract void socialUnreadFriendRequestCountChanged(int, int);
        LookupJavaMethod(jEnv, info, "socialFriendRequestRemoved", "(IILtv/twitch/social/SocialFriendRequestRemovedReason;)V"); // public abstract void socialFriendRequestRemoved(int, int, tv.twitch.social.SocialFriendRequestRemovedReason);
        LookupJavaMethod(jEnv, info, "socialPresenceSettingsChanged", "(ILtv/twitch/social/SocialPresenceSettings;)V"); // public abstract void socialPresenceSettingsChanged(int, tv.twitch.social.SocialPresenceSettings);
    }

    return info;
}
