/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialfriend.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialFriend(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialFriend");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialFriend();

        LookupJavaMethod(jEnv, info, "dateFromFriendsSinceTimestamp", "()Ljava/util/Date;"); // public java.util.Date dateFromFriendsSinceTimestamp();

        LookupJavaField(jEnv, info, "userInfo", "Ltv/twitch/UserInfo;"); // public tv.twitch.UserInfo userInfo;
        LookupJavaField(jEnv, info, "friendsSinceTime", "I"); // public int friendsSinceTime;
        LookupJavaField(jEnv, info, "presence", "Ltv/twitch/social/SocialPresence;"); // public tv.twitch.social.SocialPresence presence;
    }

    return info;
}
