/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialfriendrequest.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialFriendRequest(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialFriendRequest");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialFriendRequest();

        LookupJavaMethod(jEnv, info, "dateFromRequestTimestamp", "()Ljava/util/Date;"); // public java.util.Date dateFromRequestTimestamp();

        LookupJavaField(jEnv, info, "userInfo", "Ltv/twitch/UserInfo;"); // public tv.twitch.UserInfo userInfo;
        LookupJavaField(jEnv, info, "requestTime", "I"); // public int requestTime;
    }

    return info;
}
