/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialpresence.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialPresence(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialPresence");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialPresence();

        LookupJavaMethod(jEnv, info, "dateFromLastPresenceUpdateTimestamp", "()Ljava/util/Date;"); // public java.util.Date dateFromLastPresenceUpdateTimestamp();

        LookupJavaField(jEnv, info, "lastPresenceUpdateTime", "I"); // public int lastPresenceUpdateTime;
        LookupJavaField(jEnv, info, "availability", "Ltv/twitch/social/SocialPresenceUserAvailability;"); // public tv.twitch.social.SocialPresenceUserAvailability availability;
        LookupJavaField(jEnv, info, "activity", "Ltv/twitch/social/SocialPresenceActivity;"); // public tv.twitch.social.SocialPresenceActivity activity;
    }

    return info;
}
