/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialpresenceactivitybroadcasting.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialPresenceActivityBroadcasting(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialPresenceActivityBroadcasting");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialPresenceActivityBroadcasting();

        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "channelLogin", "Ljava/lang/String;"); // public java.lang.String channelLogin;
        LookupJavaField(jEnv, info, "channelDisplayName", "Ljava/lang/String;"); // public java.lang.String channelDisplayName;
        LookupJavaField(jEnv, info, "gameId", "I"); // public int gameId;
        LookupJavaField(jEnv, info, "gameName", "Ljava/lang/String;"); // public java.lang.String gameName;
    }

    return info;
}
