/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialpresenceactivitywatching.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialPresenceActivityWatching(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialPresenceActivityWatching");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialPresenceActivityWatching();

        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "channelLogin", "Ljava/lang/String;"); // public java.lang.String channelLogin;
        LookupJavaField(jEnv, info, "channelDisplayName", "Ljava/lang/String;"); // public java.lang.String channelDisplayName;
        LookupJavaField(jEnv, info, "hostedChannelId", "I"); // public int hostedChannelId;
        LookupJavaField(jEnv, info, "hostedChannelLogin", "Ljava/lang/String;"); // public java.lang.String hostedChannelLogin;
        LookupJavaField(jEnv, info, "hostedChannelDisplayName", "Ljava/lang/String;"); // public java.lang.String hostedChannelDisplayName;
        LookupJavaField(jEnv, info, "gameId", "I"); // public int gameId;
        LookupJavaField(jEnv, info, "gameName", "Ljava/lang/String;"); // public java.lang.String gameName;
    }

    return info;
}
