/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/social/internal/pch.h"
#include "twitchsdk/social/generated/java_socialpresencesettings.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SocialPresenceSettings(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/social/SocialPresenceSettings");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.social.SocialPresenceSettings();

        LookupJavaField(jEnv, info, "availabilityOverride", "Ltv/twitch/social/SocialPresenceAvailabilityOverride;"); // public tv.twitch.social.SocialPresenceAvailabilityOverride availabilityOverride;
        LookupJavaField(jEnv, info, "shareActivity", "Z"); // public boolean shareActivity;
    }

    return info;
}
