/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/social/internal/pch.h"

#include "twitchsdk/social/java_socialapilistenerproxy.h"

#include "twitchsdk/social/generated/java_all.h"
#include "twitchsdk/social/java_socialutil.h"

using namespace ttv::social;

ttv::binding::java::JavaSocialAPIListenerProxy::JavaSocialAPIListenerProxy(jobject jModule)
    : NativeModuleListener(jModule) {
  mListenerInfo = GetJavaClassInfo_ISocialAPIListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialFriendInfoChanged(
  UserId userId, const std::vector<Friend>& changes) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobjectArray, jChanges, GetJavaInstance_SocialFriendArray(gActiveJavaEnvironment, changes));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["socialFriendInfoChanged"], static_cast<jint>(userId), jChanges);
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialFriendshipChanged(
  UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobjectArray, jAdded, GetJavaInstance_SocialFriendArray(gActiveJavaEnvironment, added));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobjectArray, jRemoved, GetJavaInstance_SocialFriendArray(gActiveJavaEnvironment, removed));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["socialFriendshipChanged"], static_cast<jint>(userId), jAdded, jRemoved);
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialRealtimeFriendRequestReceived(
  UserId userId, const FriendRequest& request) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRequest, GetJavaInstance_SocialFriendRequest(gActiveJavaEnvironment, request));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["socialRealtimeFriendRequestReceived"], static_cast<jint>(userId), jRequest);
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialUnreadFriendRequestCountChanged(
  UserId userId, uint32_t count) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["socialUnreadFriendRequestCountChanged"],
    static_cast<jint>(userId), static_cast<jint>(count));
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialFriendRequestRemoved(
  UserId userId, UserId otherUserId, FriendRequestRemovalReason reason) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jReason,
    GetJavaInstance_SimpleEnum(
      gActiveJavaEnvironment, GetJavaClassInfo_SocialFriendRequestRemovedReason(gActiveJavaEnvironment), reason));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["socialFriendRequestRemoved"],
    static_cast<jint>(userId), static_cast<jint>(otherUserId), jReason);
}

void ttv::binding::java::JavaSocialAPIListenerProxy::SocialPresenceSettingsChanged(
  UserId userId, const PresenceSettings& settings) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jSettings,
    GetJavaInstance_SocialPresenceSettings(gActiveJavaEnvironment, settings));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["socialPresenceSettingsChanged"], static_cast<jint>(userId), jSettings);
}
