/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/social/internal/pch.h"

#include "twitchsdk/social/java_socialtest.h"

#include "twitchsdk/core/stringutilities.h"
#include "twitchsdk/social/java_socialapilistenerproxy.h"
#include "twitchsdk/social/java_socialutil.h"

using namespace ttv;
using namespace ttv::social;
using namespace ttv::binding::java;

namespace {
std::vector<Friend> SampleFriendList() {
  // Stack allocate the temporary friends
  std::vector<Friend> friends;

  friends.resize(3);
  friends[0].friendsSinceTime = 12345;
  friends[0].presenceStatus.availability = PresenceUserAvailability::Away;
  friends[0].presenceStatus.lastUpdate = 122334;

  auto watchingActivity = std::make_unique<WatchingActivity>();
  watchingActivity->channelId = 4567;
  watchingActivity->channelLogin = "watchedchannellogin";
  watchingActivity->channelDisplayName = "Watched Channel Display Name";
  watchingActivity->hostedChannelId = 7890;
  watchingActivity->hostedChannelLogin = "hostedchannellogin";
  watchingActivity->hostedChannelDisplayName = "Hosted Channel Display Name";
  watchingActivity->gameId = 7007;
  watchingActivity->gameName = "Megaman X";
  friends[0].presenceStatus.activity = std::move(watchingActivity);
  friends[0].userInfo.bio = "bio0";
  friends[0].userInfo.createdTimestamp = 111111;
  friends[0].userInfo.displayName = "displayName0";
  friends[0].userInfo.logoImageUrl = "logo0";
  friends[0].userInfo.userId = 11;
  friends[0].userInfo.userName = "userName0";

  friends[1].friendsSinceTime = 23345;
  friends[1].presenceStatus.availability = PresenceUserAvailability::Busy;
  friends[1].presenceStatus.lastUpdate = 354234;

  auto playingActivity = std::make_unique<PlayingActivity>();
  playingActivity->gameId = 1337;
  playingActivity->gameName = "Super Metroid";
  playingActivity->gameDisplayContext = "Ceres Station Escape";
  friends[1].presenceStatus.activity = std::move(playingActivity);

  friends[1].userInfo.bio = "bio1";
  friends[1].userInfo.createdTimestamp = 111111;
  friends[1].userInfo.displayName = "displayName1";
  friends[1].userInfo.logoImageUrl = "logo1";
  friends[1].userInfo.userId = 22;
  friends[1].userInfo.userName = "userName1";

  friends[2].friendsSinceTime = 27789;
  friends[2].presenceStatus.availability = PresenceUserAvailability::Online;
  friends[2].presenceStatus.lastUpdate = 734647;

  auto broadcastingActivity = std::make_unique<BroadcastingActivity>();
  broadcastingActivity->channelId = 101010;
  broadcastingActivity->channelLogin = "broadcastinglogin";
  broadcastingActivity->channelDisplayName = "Broadcasting Display Name";
  broadcastingActivity->gameId = 9009;
  broadcastingActivity->gameName = "Bubble Bobble";

  friends[2].presenceStatus.activity = std::move(broadcastingActivity);
  friends[2].userInfo.bio = "bio2";
  friends[2].userInfo.createdTimestamp = 111111;
  friends[2].userInfo.displayName = "displayName2";
  friends[2].userInfo.logoImageUrl = "logo2";
  friends[2].userInfo.userId = 33;
  friends[2].userInfo.userName = "userName2";

  return friends;
}

FriendRequest SampleFriendRequest() {
  FriendRequest request;

  request.requestTime = 12345;
  request.userInfo.bio = "bio0";
  request.userInfo.createdTimestamp = 111111;
  request.userInfo.displayName = "displayName0";
  request.userInfo.logoImageUrl = "logo0";
  request.userInfo.userId = 11;
  request.userInfo.userName = "userName0";

  return request;
}
}  // namespace

JNIEXPORT void JNICALL Java_tv_twitch_test_SocialTest_Test_1ISocialAPIListener(
  JNIEnv* jEnv, jobject /*jThis*/, jobject jModule, jobject jListener) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  LoadAllUtilityJavaClassInfo(jEnv);
  LoadAllCoreJavaClassInfo(jEnv);
  LoadAllSocialJavaClassInfo(jEnv);

  {
    auto listener = std::make_shared<JavaSocialAPIListenerProxy>(jModule);
    listener->SetListener(jListener);

    listener->ModuleStateChanged(nullptr, IModule::State::Initialized, TTV_EC_SUCCESS);

    std::vector<Friend> friendList = SampleFriendList();
    std::vector<Friend> secondFriendList = SampleFriendList();
    listener->SocialFriendInfoChanged(9001, friendList);
    listener->SocialFriendshipChanged(9001, friendList, secondFriendList);

    listener->SocialRealtimeFriendRequestReceived(9001, SampleFriendRequest());

    listener->SocialUnreadFriendRequestCountChanged(9001, 5);
    listener->SocialFriendRequestRemoved(9001, 9002, FriendRequestRemovalReason::SelfRejected);

    PresenceSettings settings;
    settings.availabilityOverride = PresenceSettings::AvailabilityOverride::Offline;
    settings.shareActivity = false;
    listener->SocialPresenceSettingsChanged(9001, settings);
  }
}
