import argparse
import imp
import os

# Load the generator script as a module we can call into
tools_dir = os.path.realpath(os.path.dirname(__file__))
generate_module = imp.load_source('generate_class_info_func', os.path.join(tools_dir, '..', '..', '..', '..', 'build/tools/bindings/java', 'generate_native_java_class_info.py'))

generated_header_paths = []

def generate(class_names):

    # Generate each type we care about
    for class_name in class_names:
        sanitized_class_name = class_name.lower().replace('$', '_')

        hpp = hpp_prefix + 'java_' + sanitized_class_name.lower() + '.h'
        cpp = cpp_prefix + 'java_' + sanitized_class_name.lower() + '.cpp'

        class_name = java_namespace + '.' + class_name

        generate_module.generate(
            java_class_name=class_name,
            class_path=class_path,
            hpp_path=hpp,
            cpp_path=cpp,
            pch_path=pch,
            namespace=cpp_namespace)

        generated_header_paths.append(hpp)


# Classes
class_names = [
    'SocialAPI$PostPresenceCallback',
    'SocialAPI$FetchPresenceSettingsCallback',
    'SocialAPI$SetPresenceSettingsCallback',
    'SocialAPI$FetchFriendListCallback',
    'SocialAPI$UpdateFriendshipCallback',
    'SocialAPI$FetchFriendRequestsCallback',
    'SocialAPI$FetchUnreadFriendRequestCountCallback',
    'SocialAPI$MarkAllFriendRequestsReadCallback',
    'SocialAPI$FetchFriendStatusCallback',
    'SocialAPI$FetchRecommendedFriendsCallback',
    'SocialAPI$DismissRecommendedFriendCallback',

    'ISocialAPIListener',
    'SocialFeatureFlags',
    'SocialFriend',
    'SocialFriendRequest',
    'SocialFriendRequestRemovedReason',
    'SocialFriendStatus',
    'SocialPresence',
    'SocialPresenceActivity',
    'SocialPresenceActivityBroadcasting',
    'SocialPresenceActivityPlaying',
    'SocialPresenceActivityType',
    'SocialPresenceActivityWatching',
    'SocialPresenceAvailabilityOverride',
    'SocialPresenceSessionAvailability',
    'SocialPresenceUserAvailability',
    'SocialPresenceSettings',
    'SocialUpdateFriendAction',
    'SocialUpdateFriendResult'
]

try:
    class_path = os.environ['TTV_JAVA_BINDINGS_BIN_PATH']
except KeyError:
    raise EnvironmentError('Set TTV_JAVA_BINDINGS_BIN_PATH environment variable to use.')

java_namespace = 'tv.twitch.social'
cpp_namespace = 'ttv::binding::java'
hpp_prefix = os.path.join(tools_dir, '../include/twitchsdk/social/generated/')
cpp_prefix = os.path.join(tools_dir, '../source/generated/')
pch = 'twitchsdk/social/internal/pch.h'

dest_dir = os.path.realpath(os.path.dirname(hpp_prefix))
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

dest_dir = os.path.realpath(os.path.dirname(cpp_prefix))
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

generate(class_names)


# Generate the header file to include all the generated header files
master_header_path = hpp_prefix + 'java_all.h'
file = open(master_header_path, 'w')
file.write(generate_module.copyright() + """#pragma once

""")

for path in generated_header_paths:
    include_path = generate_module.determine_header_include_path(path)

    if include_path:
        file.write('#include "' + include_path + '"' + "\n")


file.write("\n")
file.close()
