#Tracking
This is the ```Tracking``` module which implements tracking. It provides the following services:

* Batched sending of tracking events to Spade

This module relies on the ```Core``` module which is found in its own repository.

#Build
See the ```Core``` repository on how to build the Twitch SDK.  Use the ```--module=tracking`` to include this module in the generation of the Twitch SDK library.

#Usage
```TrackingAPI``` is the primary interface into this module. Before initialization, the client should configure the following:
* The CoreAPI of the SDK that should manage the TrackingAPI.

The tracking module, by default, batches requests made to tracking endpoints. A call to ```TrackEvent``` enqueues the event for dispatch within the next batch, returning (via writing to a client-provided reference) an ID uniquely identifying that event. A batch of events will dispatch to all tracking endpoints when one of three conditions is met:

* An amount of time equal to the flush interval has elapsed since the last call to ```TrackEvent```
* The number of events in the batch has reached the maximum allowed.
* Adding the event via ```TrackEvent``` would cause the number of bytes in the batch exceeds the maximum allowed. In this case, the batch is dispatched and the event is added to the next batch.

The client can tune these limits before initializing ```TrackingAPI```, though defaults are provided.

The client is able to register a ```TrackingAPIListener``` with the ```TrackingAPI``` in order to receive callbacks signaling various events in the ```TrackingAPI```. The callbacks provide batch start and batch end IDs, corresponding to the range of batched eventIDs (as returned by ```TrackEvent```) that the callback is firing for. While the module does have some retry logic internally for HTTP requests made to tracking endpoints, it is ultimately the responsibility of the client to ensure all critical events have been successfully sent.

#Tests
See the ```Core``` repository on how to build the Twitch SDK tests.  Use the ```--module=tracking`` to include this module in the generation of the Twitch SDK tests.

#Samples
See the ```Core``` repository on how to build the Twitch SDK samples.  Use the ```--module=tracking``` to include this module in the generation of the Twitch SDK samples.
The ```tracking``` CLI sample provides access to all of the public-facing functions of ```TrackingAPI```.

#TODO
* Add ability to target arbitrary tracking endpoints (for usage with tracking validators, for example)
* Add validation of events with Science-provided event schema
