#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace tracking {
class TrackingRequestTask;
}
}  // namespace ttv

class ttv::tracking::TrackingRequestTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(TrackingRequestTask* source, const std::string& serverUrl, TTV_ErrorCode ec)>;

 public:
  TrackingRequestTask(const std::string& serverUrl, const std::string& batchJson, Callback&& callback);

  void ResponseCallback(uint statusCode, const std::vector<char>& response) override;
  void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "TrackingRequestTask"; }
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

 private:
  Callback mCallback;
  std::string mServerUrl;
  std::string mBatchJson;
};
