/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/module.h"
#include "twitchsdk/core/types/coretypes.h"

namespace ttv {
namespace tracking {
class ITrackingAPIListener;
}
}  // namespace ttv

class ttv::tracking::ITrackingAPIListener : public IModuleListener {
 public:
  /**
   * Fired whenever a tracking event flush attempt is completed.
   * If the batch fails to be sent then the events will be queued to be sent again later if there is
   * sufficient room for them to be stored.
   *
   * @param ec Whether or not the batch succeeded to be sent.
   * @param numEvents The number of events that were in the batch.
   */
  virtual void TrackingEventFlushCompleted(TTV_ErrorCode ec, uint32_t numEvents) = 0;

  /**
   * Fired whenever the tracking library must discard events because the library is being shutdown or batches
   * have been failing and there is no more memory available to store them for later sending.
   *
   * @param numEvents The number of events that were discarded.
   */
  virtual void TrackingEventsDiscarded(uint32_t numDiscarded) = 0;
};
