/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"

#include <vector>

/**
 * The unique module identifier used in tracking.
 */
const uint32_t TTV_MODULE_ID_TWITCH_TRACKING = 5;

// NOTE: There are currently no custom error ids
#define TTV_TRACKING_ERROR_IDS                  \
  BEGIN_ERROR_IDS(TTV_EC_TRACKING_BEGIN_ERRORS) \
  END_ERROR_IDS(TTV_EC_TRACKING_END_ERRORS)

#define USE_TTV_ERROR_ID(ec) ec,
#define USE_TTV_SUCCESS_ID(ec) ec = 0,
#define BEGIN_ERROR_IDS(ec) ec = CONSTRUCT_ERROR_ID_VALUE(TTV_MODULE_ID_TWITCH_TRACKING, 1),
#define END_ERROR_IDS(ec) ec

/**
 * TTV_TrackingErrorId - The error ids defined in tracking.
 */
enum TTV_TrackingErrorId { TTV_TRACKING_ERROR_IDS };

#undef BEGIN_ERROR_IDS
#undef END_ERROR_IDS
#undef USE_TTV_SUCCESS_ID
#undef USE_TTV_ERROR_ID

namespace ttv {
namespace tracking {
/**
 * Converts a strongly typed TTV_TrackingErrorId to TTV_ErrorCode so it can be handled generically.
 */
inline TTV_ErrorCode ToErrorCode(TTV_TrackingErrorId errorId) {
  return CONSTRUCT_ERROR_ID_VALUE(TTV_MODULE_ID_TWITCH_TRACKING, errorId);
}

/**
 * The error code string lookup for tracking.  This is not normally used directly by clients.  Use ttv::ErrorToString()
 * instead.
 */
const char* TrackingErrorToString(TTV_ErrorCode ec);

void GetTrackingErrorCodeValues(std::vector<EnumValue>& result);
}  // namespace tracking
}  // namespace ttv
