#include "twitchsdk/tracking/internal/pch.h"

#include "twitchsdk/tracking/internal/task/trackingrequesttask.h"

#include "twitchsdk/core/base64.h"
#include "twitchsdk/tracking/trackingapi.h"

namespace {
using namespace ttv;
using namespace ttv::tracking;
}  // namespace

TrackingRequestTask::TrackingRequestTask(
  const std::string& serverUrl, const std::string& batchJson, Callback&& callback)
    : HttpTask(nullptr, nullptr, nullptr),
      mCallback(std::move(callback)),
      mServerUrl(serverUrl),
      mBatchJson(batchJson) {
  ttv::trace::Message("TrackingRequestTask", MessageLevel::Info, "TrackingRequestTask created");
}

void TrackingRequestTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  requestInfo.requestHeaders.push_back(ttv::HttpParam("Content-Type", "application/x-www-form-urlencoded"));

  requestInfo.url = mServerUrl;
  requestInfo.httpReqType = HTTP_POST_REQUEST;

  std::string encodedBatch = Base64Encode(
    reinterpret_cast<const unsigned char*>(mBatchJson.c_str()), static_cast<unsigned int>(mBatchJson.length()));
  requestInfo.requestBody = "data=" + encodedBatch;
}

void TrackingRequestTask::ResponseCallback(uint statusCode, const std::vector<char>& /*response*/) {
  if (!mAborted) {
    if (Is2XX(statusCode)) {
      mTaskStatus = TTV_EC_SUCCESS;
    }
    // A communication issue with the backend or server error
    else if (statusCode == 0 || Is5XX(statusCode)) {
      mTaskStatus = TTV_EC_REQUEST_TIMEDOUT;
    }
    // Some HTTP error
    else {
      ttv::trace::Message("TrackingRequestTask", MessageLevel::Error, "TrackingRequestTask failed with status code: %u",
        static_cast<uint32_t>(statusCode));

      mTaskStatus = TTV_EC_API_REQUEST_FAILED;
    }
  } else {
    mTaskStatus = TTV_EC_REQUEST_ABORTED;
  }
}

void TrackingRequestTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mServerUrl, mTaskStatus.ec);
  }
}
