/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/
#pragma once

#include "fixtures/sdkbasetest.h"
#include "testhttprequest.h"
#include "trackingapitestmanager.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk/tracking/trackingapi.h"
#include "twitchsdk/tracking/trackingapilistener.h"

#include "gtest/gtest.h"

namespace ttv {
namespace tracking {
class TrackingAPITestManager;

enum TrackingBatchStatus { TTV_TRACKING_BATCH_SUCCEEDED, TTV_TRACKING_BATCH_FAILED, TTV_TRACKING_BATCH_DISCARDED };

struct TrackingBatch {
  uint32_t numEvents;
  TrackingBatchStatus status;

  TrackingBatch(uint32_t numEvents, TrackingBatchStatus status) : numEvents(numEvents), status(status) {}
};
}  // namespace tracking
}  // namespace ttv

class TrackingAPITest : public ttv::test::SdkBaseTest {
 public:
  TrackingAPITest();
  ~TrackingAPITest();

  // For testing, we configure the tracking API with lower values than production defaults.
  static const uint32_t kTestingFlushIntervalInMs = 100;
  static const uint32_t kTestingMaxBytesInBatch = 1024 * 5;  // 5 KB

 protected:
  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::tracking::TrackingAPI> mTrackingApi;

  std::shared_ptr<ttv::tracking::TrackingAPITestManager> mTrackingApiTestManager;

  std::shared_ptr<MockResponse> mSpadeResponse;

  virtual void SetUpStubs() override;
  virtual void SetUpComponents() override;
  virtual void TearDownComponents() override;

  // Test will hang if this is called and test is not properly written to return up to eventId
  void UpdateUntilEventFlushed(uint32_t maxWaitInMs, uint32_t eventId);

  bool CheckEventHasStatus(uint32_t eventId, ttv::tracking::TrackingBatchStatus status);

  void AssertEventSucceeded(uint32_t eventId);
  void AssertEventNotSucceeded(uint32_t eventId);

  void AssertEventFailed(uint32_t eventId);
  void AssertEventNotFailed(uint32_t eventId);

  void AssertEventDiscarded(uint32_t eventId);
  void AssertEventNotDiscarded(uint32_t eventId);

  void SetResponsesAsSucceeding();
  void SetResponsesAsFailing(uint32_t statusCode);
};
