/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/trackingapitest.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk/core/module.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/tracking/trackingapilistener.h"

namespace ttv {
namespace tracking {
class TrackingAPITestManager;
struct TrackingBatch;
}  // namespace tracking
}  // namespace ttv

class ttv::tracking::TrackingAPITestManager : public ITrackingAPIListener {
 public:
  TrackingAPITestManager();
  ~TrackingAPITestManager();

  // ITrackingAPIListener implementation
  void ModuleStateChanged(IModule* source, IModule::State state, TTV_ErrorCode ec);
  void TrackingEventFlushCompleted(TTV_ErrorCode ec, uint32_t numEvents);
  void TrackingEventsDiscarded(uint32_t numDiscarded);

  std::vector<TrackingBatch> mCompletedBatches;
};
