/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/tracking/internal/pch.h"

#include "trackingapitestmanager.h"

#include "fixtures/trackingapitest.h"
#include "twitchsdk/core/module.h"
#include "twitchsdk/tracking/trackingapi.h"
#include "twitchsdk/tracking/trackingapilistener.h"

ttv::tracking::TrackingAPITestManager::TrackingAPITestManager() {}

ttv::tracking::TrackingAPITestManager::~TrackingAPITestManager() {}

void ttv::tracking::TrackingAPITestManager::ModuleStateChanged(
  IModule* /*source*/, IModule::State /*state*/, TTV_ErrorCode /*ec*/) {}

void ttv::tracking::TrackingAPITestManager::TrackingEventFlushCompleted(TTV_ErrorCode ec, uint32_t numEvents) {
  switch (ec) {
    case TTV_EC_SUCCESS:
      mCompletedBatches.emplace_back(TrackingBatch(numEvents, TTV_TRACKING_BATCH_SUCCEEDED));
      break;
    default:
      mCompletedBatches.emplace_back(TrackingBatch(numEvents, TTV_TRACKING_BATCH_FAILED));
      break;
  }
}

void ttv::tracking::TrackingAPITestManager::TrackingEventsDiscarded(uint32_t numDiscarded) {
  mCompletedBatches.emplace_back(TrackingBatch(numDiscarded, TTV_TRACKING_BATCH_DISCARDED));
}
