import __future__

import argparse
import os
import subprocess
import sys

from teamcity_helper.teamcitytest import TeamcityTest


def is_python_3():
    return sys.version_info >= (3, 0)


def run_command(input, split=True):
    if is_python_3():
        process = subprocess.Popen(input,
                                   stdout=subprocess.PIPE,
                                   encoding='utf8')
    else:
        process = subprocess.Popen(input, stdout=subprocess.PIPE)

    stdout, stderr = process.communicate()
    if process.returncode != 0:
        sys.exit(process.returncode)
    if split == True:
        return stdout.splitlines()
    else:
        return stdout


teamcity_test = TeamcityTest('clangFormatTest')

teamcity_test.test_started()

# set path to current file
os.chdir(os.path.dirname(os.path.realpath(__file__)))

# we can now run git to get root path and set it as our new working path
os.chdir(run_command(['git', 'rev-parse', '--show-toplevel'], True)[0])

teamcity_test.info_message('Running formatting test')

files = run_command(
    [sys.executable, './tools/clang/clang-format-git-files.py', '--all'], True)

has_error = False
for f in files[1:]:
    diff_output = run_command(['git', 'diff', '-U0', '--no-color', f], False)
    if diff_output:
        has_error = True
        teamcity_test.failed_message_with_details('Replacements Needed',
                                                  diff_output)

teamcity_test.test_finished()

teamcity_test.sys_exit_with_rc()
