import __future__

import sys


# This class is intended to create a common TeamCity Test harness that conforms to the
# teamcity message standard.  This will help when developing tests and correctly sending
# messages to the team city output to inform the user of passing and failing tests
class TeamcityTest:

    def __init__(self, test_name):
        self.test_name = test_name
        self.tests_passed = True

    def __str__(self):
        return "TeamcityTest - " + self.test_name

    def escape_message(self, output):
        output = output.replace("|", "||")
        output = output.replace("'", "|'")
        output = output.replace("\n", "|n")
        output = output.replace("\r", "|r")
        output = output.replace("[", "|[")
        output = output.replace("]", "|]")

        return output

    def test_started(self):
        print("##teamcity[testStarted name='{test_name}']".format(
            test_name=self.test_name))

    def test_finished(self):
        print("##teamcity[testFinished name='{test_name}']".format(
            test_name=self.test_name))

    def failed_message(self, message):
        self.tests_passed = False
        print("##teamcity[testFailed name='{test_name}' message='{message}']".
              format(test_name=self.test_name,
                     message=self.escape_message(message)))

    def failed_message_with_details(self, message, failure_details):
        self.tests_passed = False
        print(
            "##teamcity[testFailed name='{test_name}' message='{message}' details='{failure_details}']"
            .format(test_name=self.test_name,
                    message=self.escape_message(message),
                    failure_details=self.escape_message(failure_details)))

    def info_message(self, message):
        print(
            "##teamcity[testStdOut name='{test_name}' out='{message}']".format(
                test_name=self.test_name, message=self.escape_message(message)))

    def did_tests_pass(self):
        return self.tests_passed

    # This calls system exit with the standard return code for passing/failure, 0 for passing 1 for failing
    def sys_exit_with_rc(self):
        if self.did_tests_pass():
            sys.exit(0)
        else:
            sys.exit(1)


# def sample_usage():
#     test = TeamcityTest("formating tests")
#     test.test_started()
#     # Run tests and get output
#     test.info_message("Complete subtest 1")
#     test.info_message("Complete subtest 2")
#     test.failed_message("Failed subtest 3")
#     test.failed_message_with_details("Failed subtest 4", "console output data")
#     test.test_finished()
#     test.sys_exit_with_rc()
# sample_usage()
