# Clang-Format

To ensure consistancy between all platforms the same clang-format version should be used.  Build systems and users should add the versioned tools to their system path or use the versioned tool directly `tools\clang\clang-format.exe`.  Alternatively you can install you corrisponding tool using the correct version and run as needed.  Benifits of using the revisioned tools allows to use with different repositories without modifying system wide executables.

* Install llvm-7.0.1 or stand alone clang tools 7.0.1

## Usage

The script `clang-format-git-files.py` can be used to help facilitate running clang-format.  To run clang-format on valid files within the repository exectute the following commands.

For all files `python clang-format-git-files.py --all`

For modified only files `python clang-format-git-files.py`

## Requirements

clang-format-7
python 2.7.x
python 3.5.x+

`Python versions`
General good practice, if you have python 2 and python 3 installed you should rename the binaries to python2 and python3 if they are not already.  Allow the default python version to be named the python

* c:/python-2/python.exe
* c:/python-2/python2.exe
* c:/python-3/python3.exe

### OSX

#### Ensure home brew is installed

<https://docs.brew.sh/Installation>

This will install llvm 7.0.1 and make a symbolic link of clang-format to you user binary folder

``` bash
brew install llvm@7
brew list llvm@7 | grep 'bin/clang-format' | head -1 | xargs -I{} ln -s {} /usr/local/bin/clang-format-7
```

### Windows

Chocolatey is installed on Amazon provisioned computers by default, if for some reason it is not go ahead and install it:

#### Install Chocolatey

Open powershell in admin mode and paste:

``` bash
Set-ExecutionPolicy Bypass -Scope Process -Force; iex ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))
```

#### Add Chocolatey helper functions

By default chocolatey does not add helper function to user profile.  To do so you need to copy following to your user profile

``` bash
notepad.exe $Profile

$ChocolateyProfile = "$env:ChocolateyInstall\helpers\chocolateyProfile.psm1"
if (Test-Path($ChocolateyProfile)) {
  Import-Module "$ChocolateyProfile"
}
```

#### install clang-format and rename copy to clang-format-7

Restart powershell as admin

``` bash
choco install llvm --version 7.0.1 -y -s=“https://chocolatey.org/api/v2”
refreshenv
get-childitem (get-command clang-format).path | copy-item -destination {$_.directoryname +'/clang-format-7.exe'}
```

#### Visual studio integration

If you want to integrate clang with visual studio you can install `clang-power-tools` Ensure that it uses `clang-format-7` and it uses our `.clang-format` files <https://marketplace.visualstudio.com/items?itemName=caphyon.ClangPowerTools>

## Reformat branch

This section will describe how to format a branch that does not have clang-formatting implemented on it.

rebase branch to the commit prior the formatting implementation, use the following command to find the commit log

``` bash
git log origin/master --grep "TVAPPS-2789" --pretty=format:"%h"
```

Using the commit id `prior to the formatting` rebase the feature branch and fix any merge errors

if you have multiple commits on your feature branch plan on `sqash and merging` on your PR go ahead do that locally.

* checkout `feature branch`

``` bash
git fetch origin
git checkout `feature branch`
git pull origin head
```

* rebase to commit `prior to the formatting` change

``` bash
git rebase `commit id prior to formatting`
```

* run clang format on the changed files in your commit, you will need to do this for each commit in your feature branch which is why `squashing` makes it easier if its you are multiple fixup commits

These commands will checkout your modified files so that can be formatted and then commit them to the same commit log

``` bash
git stash # your repo needs to be clean so stash or reset --hard your repo #
git reset --soft HEAD~
python .\tools\clang\clang-format-git-files.py
git add -u
git commit -c ORIG_HEAD --no-edit
```

* rebase you branch to the formatted changes and accept your formatting edits

Find formatted commit-id

``` bash
git log origin/master --grep "Running clang-format on codebase" --pretty=format:"%h"
```

rebase and accept your changes

``` bash
git rebase -Xtheirs `formatted commit id`
```

* update branch to lastest master, should be error free now

``` bash
git pull origin master --rebase
```
