Twitch Unity Plugin Setup
=========================

Getting The Latest Release
~~~~~~~~~~~~~~~~~~~~~~~~~~
- Go to https://github.com/twitchsdk/twitchbins
- Download external-win32.zip
- Download TwitchUnity.unitypackage

Windows - Editor Setup
~~~~~~~~~~~~~~~~~~~~~~
- Import twitch.unitypackage into your project
- Unzip the following files from external-win32.zip into the Unity project root (same level as Assets)
	- avutil-ttv-51.dll
	- libcurl-ttv.dll
	- libeay32-ttv.dll
	- libeay32-ttv.dll
	- libmp3lame-ttv.dll
	- ssleay32-ttv.dll
	- swresample-ttv-0.dll
- Open SampleScene.unity to see how it is set up
- Set your ClientId and ClientSecret fields on StreamController (get these through your account on the site)
- Set your usename and password in the TwitchGUI component
- Run SampleScene and play with the default GUI that displays
- To set up Twitch in your scene
	- Add the TwitchStream prefab into your scene
	- You can configure your scene to use a static RenderTexture (does not handle window resizes or resolution changes)
		- Create a RenderTexture asset which you will render your scene to (or create dynamically at runtime)
		- Setup your RenderTexture to render to the screen as needed
		- Link the RenderTexture to the SceneRenderTexture field in the StreamController
	- Alternatively, you can use the RenderTextureResizer (preferred)
		- Add the RenderTextureResizer to your scene
		- Hook up all cameras which render the scene to the RenderTextureResizer
		- Hook up the StreamController to the RenderTextureResizer
		- Hook up the surface (child of the StreamController) to the RenderTextureResizer

RenderTextureResizer: Responsible for handling resize events from the Unity Screen and resizing the automatically generated screen RenderTexture.  It also informs the configured cameras that they should update their projections.  When the RenderTexture is updated it is connected to the configured StreamController.

WebcamHelper: A sample component which shows how to display a webcam image in the game.  This is does not use any parts of the Twitch SDK and is merely a starting point on how to integrate into your game.

StreamController: A component which manages the streaming state.  This can be tweaked if needed but should handle all your streaming needs.

TwitchGUI: A quick and ugly UI for starting and stopping streaming.





Windows - Release Build
~~~~~~~~~~~~~~~~~~~~~~~
- Build your game
- Go the directory where it was build to
- Copy the following files to the output directory root (same level as the game's .exe file)
	- avutil-ttv-51.dll
	- libcurl-ttv.dll
	- libeay32-ttv.dll
	- libeay32-ttv.dll
	- libmp3lame-ttv.dll
	- ssleay32-ttv.dll
	- swresample-ttv-0.dll
- Copy the following files to the <gamename>_Data directory
	- curl-ca-bundle.crt



Mac Editor Setup
~~~~~~~~~~~~~~~~
* TODO



Mac Release Build
~~~~~~~~~~~~~~~~~
* TODO



iOS Editor Setup
~~~~~~~~~~~~~~~~
* You cannot test Twitch broadcasting in the Editor or Simulator, please test on a Mac build



iOS Release Build
~~~~~~~~~~~~~~~~~
* TODO
