/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#if TTV_PLATFORM_WINDOWS
#define TTV_SUPPORT_D3D9 1
#endif

#if TTV_SUPPORT_D3D9

#include "bindingframecapturer.h"
#include <d3d9.h>

namespace ttv
{
	class BindingFrameCapturer_D3D9;
}

class ttv::BindingFrameCapturer_D3D9 : public ttv::BindingFrameCapturer
{
public:
	BindingFrameCapturer_D3D9();
	virtual ~BindingFrameCapturer_D3D9();

	virtual void SetGraphicsDevice(void* device, GfxDeviceEventType::Enum eventType);
	virtual TTV_ErrorCode Stop();
	virtual TTV_ErrorCode SubmitTexture(void* p, int width, int height);

protected:
	virtual bool RequiresVerticalFlip();
	virtual void CleanupObjects();

	static const int kNumCaptureSurfaces = 4;

	IDirect3DDevice9* mGraphicsDevice;
	IDirect3DTexture9* mCaptureTexture; //!< The texture which serves as the destination of the resized output.
	IDirect3DSurface9* mCaptureSurface;
	IDirect3DQuery9* mCaptureQuery[kNumCaptureSurfaces]; //!< The pool of query requests.
	IDirect3DSurface9* mResizeSurface[kNumCaptureSurfaces];	//!< The pool of surfaces to capture to.

	IDirect3DTexture9* mMainRenderTexture;
	IDirect3DSurface9* mMainRenderTargetSurface; //!< The surface that the app renders to.

	int mCapturePut; //!< The current request to render the resized texture to the destination render target.
	int mCaptureGet; //!< The current request for the pixel data.
	int mSceneWidth;
	int mSceneHeight;
	HRESULT mPreviousDeviceStatus;
};

#endif
