/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#if TTV_PLATFORM_IOS
#define TTV_SUPPORT_GLES2 1
#endif

#if TTV_SUPPORT_GLES2

#include "bindingframecapturer.h"
#include "internal/bindings/graphics_ios_gles2.h"

namespace ttv
{
	class BindingFrameCapturer_iOS_RenderTexture_GLES2;
	
	using namespace graphics::ios;
}

class ttv::BindingFrameCapturer_iOS_RenderTexture_GLES2 : public ttv::BindingFrameCapturer
{
public:
	BindingFrameCapturer_iOS_RenderTexture_GLES2();
	virtual ~BindingFrameCapturer_iOS_RenderTexture_GLES2();

	virtual TTV_ErrorCode Start(const TTV_VideoParams* videoParams, const TTV_AudioParams* audioParams, const TTV_IngestServer* ingestServer, uint32_t flags);
	virtual TTV_ErrorCode Stop();
	virtual TTV_ErrorCode SubmitTexture(void* p, int width, int height);

protected:
	virtual void CleanupObjects();
	virtual bool ShouldCreateFrameBuffers() const;
	virtual void HandleBufferUnlock(const uint8_t* buffer);
		
	typedef std::vector< std::shared_ptr<RenderTexture> > TextureList;
	
	std::shared_ptr<RenderTexture> UnlockTexture(const void* buffer);
	bool CheckError();

	FrameBuffer mResizeFrameBuffer;
	QuadShader mQuadShader;
	Quad mBroadcastQuad;
	TextureCache mTextureCache;
	
	TextureList mFreeTextures; //!< Textures which are free to render to.
	TextureList mPendingTextures; //!< Textures which are being rendered to.
	TextureList mLockedTextures; //!< Textures which have been locked and have been submitted to the sdk.
	
	int mRenderTextureCount; //!< The number of textures to use for delay.
	int mSceneWidth;
	int mSceneHeight;
};

#endif
