/********************************************************************************************
 * Twitch Broadcasting SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 *********************************************************************************************/

#pragma once

#if TTV_PLATFORM_IOS
#define TTV_SUPPORT_GLES2 1
#endif


#if TTV_SUPPORT_GLES2

#include "bindingframecapturer_ios_rendertexture_gles2.h"
#include "internal/bindings/graphics_common_gl.h"

namespace ttv
{
	class BindingFrameCapturer_iOS_Swizzle_GLES2;
	
	using namespace graphics::ios;
}

class ttv::BindingFrameCapturer_iOS_Swizzle_GLES2 : public ttv::BindingFrameCapturer_iOS_RenderTexture_GLES2
{
public:
	BindingFrameCapturer_iOS_Swizzle_GLES2();
	virtual ~BindingFrameCapturer_iOS_Swizzle_GLES2();
	
	virtual TTV_ErrorCode Start(const TTV_VideoParams* videoParams, const TTV_AudioParams* audioParams, const TTV_IngestServer* ingestServer, uint32_t flags);
	virtual TTV_ErrorCode Stop();
	virtual TTV_ErrorCode PauseFrameSubmission();
	virtual TTV_ErrorCode ResumeFrameSubmission();
	virtual TTV_ErrorCode SubmitTexture(void* p, int width, int height);
	
	// Called from swizzled methods
	virtual void BindGameFramebuffer();
	virtual TTV_ErrorCode CaptureBoundRenderbuffer();
	virtual TTV_ErrorCode DrawScreenQuad();
	virtual bool SetupCapture();
	virtual bool RevertSetup();
	
	bool IsSetUpForCapture() const { return mIsSetupForCapture; }
	bool IsFrameSubmissionPaused() const { return mIsFrameSubmissionPaused; }
	
	static void SetInstance(std::shared_ptr<BindingFrameCapturer_iOS_Swizzle_GLES2> p) { sInstance = p; }
	static std::shared_ptr<BindingFrameCapturer_iOS_Swizzle_GLES2> GetInstance() { return sInstance; }
	
protected:
	
	RenderTexture mScreenTexture;
	FrameBuffer mScreenFrameBuffer;
	Quad mScreenQuad;
	QuadShader mScreenQuadShader;
	
	static std::shared_ptr<BindingFrameCapturer_iOS_Swizzle_GLES2> sInstance;
	
	GLint mGameFrameBufferId;
	GLint mGameRenderBufferId;
	bool mIsSetupForCapture; // Whether or not the renderbuffer is setup for capturing.
	bool mIsFrameSubmissionPaused;
	
	virtual void CleanupObjects();
	
	bool CheckError();
};

#endif
