/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#if TTV_PLATFORM_WINDOWS || TTV_PLATFORM_MAC
#	define TTV_SUPPORT_OPENGL2 1
#endif

#if TTV_SUPPORT_OPENGL2

#include "bindingframecapturer.h"
#include "internal/bindings/graphics_opengl2.h"


namespace ttv
{
	class BindingFrameCapturer_OpenGL2;
	
	using namespace graphics::opengl2;
}

class ttv::BindingFrameCapturer_OpenGL2 : public ttv::BindingFrameCapturer
{
public:
	BindingFrameCapturer_OpenGL2();
	virtual ~BindingFrameCapturer_OpenGL2();

	virtual void SetGraphicsDevice(void* device, GfxDeviceEventType::Enum eventType);
	virtual TTV_ErrorCode Start(const TTV_VideoParams* videoParams, const TTV_AudioParams* audioParams, const TTV_IngestServer* ingestServer, uint32_t flags);
	virtual TTV_ErrorCode SubmitTexture(void* p, int width, int height);

protected:
	
	struct Snapshot
	{
		RenderTexture rt;
		GenericBuffer buffer;
		Query query;
		uint8_t* copied;
		int size;
		
		Snapshot();
		~Snapshot();

		void Create(uint width, uint height);
		void Destroy();
		void Forget();

		void CacheBuffer(void* locked, int size);
	};
	
	typedef std::vector< std::shared_ptr<Snapshot> > SnapshotList;

	virtual void CleanupObjects();
	virtual bool ShouldCreateFrameBuffers() const;
	virtual void HandleBufferUnlock(const uint8_t* buffer);
	bool CreateObjects();
	std::shared_ptr<Snapshot> UnlockTexture(const void* buffer);
	
	bool CheckError();
	
	DeviceContext mDeviceContext;
	FrameBuffer mResizeFrameBuffer;
	QuadShader mQuadShader;
	Quad mBroadcastQuad;
	
	SnapshotList mFreeTextures; //!< Textures which are free to render to.
	SnapshotList mPendingTextures; //!< Textures which are being rendered to.
	SnapshotList mLockedTextures; //!< Textures which have been locked and have been submitted to the sdk.
	
	int mRenderTextureCount; //!< The number of textures to use for delay.
	int mSceneWidth;
	int mSceneHeight;
	
	bool mOpenGL2Supported;

#if TTV_PLATFORM_WINDOWS
	static bool sGlewInitialized; //!< Whether or not GLEW successfully initialized.
#endif
};

#endif
