/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#include "twitchsdk.h"

// Attribute to make function be exported from a plugin
#if TTV_PLATFORM_MAC
#define EXPORT_API __attribute__((visibility("default")))
#else
#define EXPORT_API
#endif

typedef void (*TTV_BindingGenericCallback) (TTV_ErrorCode result, void* p);

extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_AllocateFrameBuffer(unsigned int size, void** buffer);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_FreeFrameBuffer(void* buffer);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_RandomizeFrameBuffer(uint8_t* buffer, unsigned int size);

extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_RequestAuthToken(const TTV_AuthParams* authParams, uint32_t flags, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_Login(const TTV_AuthToken* authToken, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_GetIngestServers(const TTV_AuthToken* authToken, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_GetUserInfo(const TTV_AuthToken* authToken, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_GetStreamInfo(const TTV_AuthToken* authToken, const char* channel, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_GetArchivingState(const TTV_AuthToken* authToken, TTV_BindingGenericCallback callback);
extern "C" EXPORT_API TTV_ErrorCode TTV_Binding_GetGameNameList(const char* str, TTV_BindingGenericCallback callback);
