/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#if TTV_PLATFORM_IOS
#define TTV_SUPPORT_GLES2 1
#endif


#if TTV_SUPPORT_GLES2

#include <OpenGLES/ES2/gl.h>
#include <OpenGLES/ES2/glext.h>
#include <CoreVideo/CVPixelBuffer.h>
#include <CoreVideo/CVOpenGLESTexture.h>
#include <CoreVideo/CVOpenGLESTextureCache.h>

@class EAGLContext;

namespace ttv
{
	namespace graphics
	{
		namespace ios
		{
			struct RenderTexture
			{
			public:
				RenderTexture();
				~RenderTexture();
				
				void Create(uint width, uint height, GLuint textureId);
				void Create(uint width, uint height, CVPixelBufferRef pb, CVOpenGLESTextureRef tx);
				void Destroy();
				
				void* Lock();
				void Unlock();
				
				void Clear(float r, float g, float b, float a);
				
				void ManuallyClearTexture();
				
				GLuint GetId();
				void* GetLocked() const { return mLocked; }
				
			private:
				CVPixelBufferRef mPixelBuffer;
				CVOpenGLESTextureRef mTexture;
				GLuint mTextureId;
				uint mWidth;
				uint mHeight;
				void* mLocked;
				bool mFromCache;
			};

			
			struct TextureCache
			{
				CVOpenGLESTextureCacheRef mTextureCache;
				
				TextureCache();
				~TextureCache();
				
				bool Create(EAGLContext* context);
				void Destroy();
				
				void Flush();
				bool CreateTexture(RenderTexture& rt, uint width, uint height, bool fromCache);
				
			private:
				CVPixelBufferRef CreatePixelBuffer(uint width, uint height);
				CVOpenGLESTextureRef AllocateTextureFromCache(uint width, uint height, CVPixelBufferRef pixelBuffer);
			};
			
			
			struct QuadShader
			{
				GLint mMvpLocation;
				GLint mTextureLocation;
				GLint mPosTexLocation;
				GLuint mProgramId;
				
				QuadShader();
				
				bool Create();
				void Destroy();
				
				void SetUniforms(float width, float height);
			};
			
			
			struct Quad
			{
			public:
				const int kNumQuadVertices = 6;
				
				GLuint mQuadAttributeArray;
				
				Quad();
				~Quad();
				
				void Create(float width, float height, bool verticalFlip);
				void Destroy();
				void Draw(const QuadShader& shader, GLint inputTextureId);
				
				float GetWidth() const { return mWidth; }
				float GetHeight() const { return mHeight; }
				
			private:
				float mWidth;
				float mHeight;
			};
			
			
			struct FrameBuffer
			{
			public:
				FrameBuffer();
				~FrameBuffer();
				
				bool Create();
				void Destroy();
				
				GLuint GetId() const { return mFrameBufferId; }
				
			private:
				GLuint mFrameBufferId;
			};
			
			bool GLCHECK();
		}
	}
}

#endif
