/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#if TTV_PLATFORM_WINDOWS || TTV_PLATFORM_MAC
#	define TTV_SUPPORT_OPENGL2 1
#endif


#if TTV_SUPPORT_OPENGL2

#if TTV_PLATFORM_WINDOWS
#	include <GL/glew.h>
#elif TTV_PLATFORM_MAC
#	include <OpenGL/OpenGL.h>
#	include <OpenGL/gl.h>
#else
#	error "Unsupported platform for OpenGL 2"
#endif


namespace ttv
{
	namespace graphics
	{
		namespace opengl2
		{
			struct DeviceContext
			{
				DeviceContext();

				void CreateFromCurrent();
				void Clear();
				bool IsCurrent();
				bool Bind();
				
#if TTV_PLATFORM_WINDOWS
				void Create(HGLRC hglrc, HDC hdc);
#elif TTV_PLATFORM_MAC
				void Create(CGLContextObj context);
#endif
								
#if TTV_PLATFORM_WINDOWS
				HGLRC mHGLRC;
				HDC mHDC;
#elif TTV_PLATFORM_MAC
				CGLContextObj mCGLContextObj;
#endif
			};
			
			struct RenderTexture
			{
			public:
				RenderTexture();
				~RenderTexture();
				
				void Create(uint width, uint height);
				void Destroy();
				void Forget();

				void Clear(float r, float g, float b, float a);
				
				void ManuallyClearTexture();
				
				GLuint GetId();
				
			private:
				GLuint mTextureId;
				uint mWidth;
				uint mHeight;
			};
			
			
			struct QuadShader
			{
				GLint mMvpLocation;
				GLint mTextureLocation;
				GLint mPosTexLocation;
				GLuint mProgramId;
				
				QuadShader();
				
				bool Create();
				void Destroy();
				void Forget();

				void SetUniforms(float width, float height);
			};
			
			
			struct Quad
			{
			public:
				static const int kNumQuadVertices = 6;
				
				GLuint mQuadAttributeArray;
				
				Quad();
				~Quad();
				
				void Create(float width, float height, bool verticalFlip);
				void Destroy();
				void Forget();

				void Draw(const QuadShader& shader, GLint inputTextureId);
				
				float GetWidth() const { return mWidth; }
				float GetHeight() const { return mHeight; }
				
			private:
				float mWidth;
				float mHeight;
			};
			
			
			struct FrameBuffer
			{
			public:
				FrameBuffer();
				~FrameBuffer();
				
				bool Create();
				void Destroy();
				void Forget();

				GLuint GetId() const { return mFrameBufferId; }
				
			private:
				GLuint mFrameBufferId;
			};
			
			struct GenericBuffer
			{
			public:
				GenericBuffer();
				~GenericBuffer();
				
				bool Create();
				void Destroy();
				void Forget();

				GLuint GetId() const { return mBufferId; }
				
			private:
				GLuint mBufferId;
			};
			
			struct Query
			{
			public:
				Query();
				~Query();
				
				bool Create();
				void Destroy();
				void Forget();
				
				void Begin();
				void End();
				bool IsReady();

			private:
				GLuint mQuery;
			};


			bool GLCHECK();
		}
	}
}

#endif
