/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/bindings/graphics_common_gl.h"

#include "twitchsdk.h"

void ttv::graphics::gl::CalculateViewport(int screenWidth, int screenHeight, int broadcastWidth, int broadcastHeight, int& vpLeft, int& vpTop, int& vpWidth, int& vpHeight)
{
	float screenAspectRatio = static_cast<float>(screenWidth) / static_cast<float>(screenHeight);
	float broadcastApectRatio = static_cast<float>(broadcastWidth) / static_cast<float>(broadcastHeight);
	
	if (broadcastApectRatio >= screenAspectRatio)
	{
		vpTop = 0;
		vpHeight = broadcastHeight;
		
		vpWidth = static_cast<int>( static_cast<float>(broadcastHeight) * screenAspectRatio );
		vpLeft = (broadcastWidth - vpWidth) / 2;
	}
	else
	{
		vpLeft = 0;
		vpWidth = broadcastWidth;
		
		vpHeight = static_cast<int>( static_cast<float>(broadcastWidth) / screenAspectRatio );
		vpTop = (broadcastHeight - vpHeight) / 2;
	}
}
