﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Twitch
{
    public unsafe struct TTV_AuthToken
    {
        public fixed byte data[128];
    }

    public class AuthToken : StructWrapperBase<TTV_AuthToken>
    {
        public AuthToken()
        {
            this.Data = "";
        }

        public unsafe AuthToken(TTV_AuthToken* p)
        {
            if (p != null)
            {
                mStruct = *p;
            }
        }

        public unsafe AuthToken(ref TTV_AuthToken p)
        {
            mStruct = p;
        }

        public AuthToken(string token)
        {
            this.Data = token;
        }

        public unsafe string Data
        {
            get
            {
                fixed (byte* b = mStruct.data)
                {
                    return MarshalUtil.StringFromBytes(b, 128);
                }
            }
            set
            {
                fixed (byte* b = mStruct.data)
                {
                    MarshalUtil.StringToBytes(value, b, 128);
                }
            }
        }

        public bool IsValid
        {
            get { return this.Data != ""; }
        }
    }
}
