using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace Twitch.Broadcast
{
    public abstract class BroadcastApi
    {
        #region Singleton

        public static BroadcastApi s_Instance = null;

        public static BroadcastApi Instance
        {
            get { return s_Instance; }
        }

        public BroadcastApi()
        {
            if (s_Instance == null)
            {
                s_Instance = this;
            }
        }

        #endregion

        #region Members

        protected IBroadcastApiListener m_BroadcastApiListener = null;
        protected IStatsListener m_StatsListener = null;
        protected bool m_InsidePollTasks = false;

        public bool IsInsidePollTasks
        {
            get { return m_InsidePollTasks; }
        }

        public abstract IBroadcastApiListener BroadcastApiListener
        {
            get;
            set;
        }

        public virtual IStatsListener StatsListener
        {
            get { return m_StatsListener; }
            set
            {
                if (m_StatsListener == value)
                {
                    return;
                }

                if (m_StatsListener != null)
                {
                    RemoveStatsCallback(m_StatsListener);
                }

                m_StatsListener = value;

                if (m_StatsListener != null)
                {
                    m_StatsListener = value;

                    RegisterStatsCallback(m_StatsListener);
                }
            }
        }

        #endregion

        #region API

        public abstract ErrorCode Initialize();
        public abstract ErrorCode Shutdown();

        public abstract ErrorCode RequestAuthToken(AuthParams authParams, AuthFlag flags);
        public abstract ErrorCode Login(AuthToken authToken);
        public abstract ErrorCode GetIngestServers(AuthToken authToken);
        public abstract ErrorCode GetUserInfo(AuthToken authToken);
        public abstract ErrorCode GetStreamInfo(AuthToken authToken, string channel);
        public abstract ErrorCode SetStreamInfo(AuthToken authToken, string channel, StreamInfoForSetting streamInfoToSet);
        public abstract ErrorCode GetArchivingState(AuthToken authToken);
        public abstract ErrorCode RunCommercial(AuthToken authToken);
        public abstract ErrorCode SetVolume(TTV_AudioDeviceType device, float volume);
        public abstract ErrorCode GetVolume(TTV_AudioDeviceType device, ref float volume);
        public abstract ErrorCode GetGameNameList(string str);
        public abstract ErrorCode GetMaxResolution(uint maxKbps, uint frameRate, float bitsPerPixel, float aspectRatio, ref uint width, ref uint height);
        public abstract ErrorCode GetDefaultParams(VideoParams vidParams);
        public abstract ErrorCode PollTasks();
        public abstract ErrorCode SendActionMetaData(AuthToken authToken, string name, UInt64 streamTime, string humanDescription, string data);
        public abstract ErrorCode SendStartSpanMetaData(AuthToken authToken, string name, UInt64 streamTime, out ulong sequenceId, string humanDescription, string data);
        public abstract ErrorCode SendEndSpanMetaData(AuthToken authToken, string name, UInt64 streamTime, ulong sequenceId, string humanDescription, string data);
        public abstract ErrorCode SubmitVideoFrame(UIntPtr frameBuffer);
        public abstract ErrorCode SubmitAudioSamples(Int16[] buffer, uint numSamples);
        public abstract ErrorCode PollStats();
        public abstract ErrorCode Start(VideoParams videoParams, AudioParams audioParams, IngestServer ingestServer, StartFlags flags, bool async);
        public abstract ErrorCode Stop(bool async);
        public abstract ErrorCode PauseVideo();
        public abstract ErrorCode AllocateFrameBuffer(uint size, out UIntPtr buffer);
        public abstract ErrorCode FreeFrameBuffer(UIntPtr buffer);
        public abstract ErrorCode RandomizeFrameBuffer(UIntPtr buffer, uint size);
        public abstract ErrorCode GetStreamTime(out UInt64 timeMs);

        public abstract ErrorCode RegisterStatsCallback(IStatsListener listener);
        public abstract ErrorCode RemoveStatsCallback(IStatsListener listener);

        #endregion
    }
}
