﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using ErrorCode = Twitch.ErrorCode;


namespace Twitch.Chat
{
    public abstract class ChatApi
    {
        #region Singleton

        internal static ChatApi s_Instance = null;

        public static ChatApi Instance
        {
            get { return s_Instance; }
        }

        #endregion

        #region Members

        public ChatApi()
        {
            if (s_Instance == null)
            {
                s_Instance = this;
            }
        }

        #endregion

        #region API

        public abstract ErrorCode Initialize(TTV_ChatTokenizationOption tokenizationOptions, IChatApiListener apiListener);
        public abstract ErrorCode Shutdown();
        public abstract ErrorCode FlushEvents();
        public abstract ErrorCode ForceUserListUpdate(string userName, string channelName);
        public abstract ErrorCode FreeMessageList(ref TTV_ChatMessageList messageList);
        public abstract ErrorCode FreeUserList(ref TTV_ChatUserList userList);

        public abstract ErrorCode LogIn(string userName, string oauthToken);
        public abstract ErrorCode LogOut(string userName);

        public abstract ErrorCode Connect(string username, string channelName, IChatChannelListener channelCallbacks);
        public abstract ErrorCode Disconnect(string username, string channelName);
        public abstract ErrorCode SendMessage(string username, string channelName, string message);

        public abstract ErrorCode BlockUser(string userName, string blockUserName);
        public abstract ErrorCode UnblockUser(string userName, string blockUserName);
        public abstract ErrorCode GetUserBlocked(string userName, string blockUserName, ref bool blocked);
        
        public abstract ErrorCode GetBadgeData(string channelName, out ChatBadgeData data);

        public abstract int GetMessageFlushInterval();
        public abstract ErrorCode SetMessageFlushInterval(int milliseconds);
        public abstract int GetUserListUpdateInterval();
        public abstract ErrorCode SetUserListUpdateInterval(int milliseconds);

        public abstract ErrorCode SetBroadcasterLanguageChatEnabled(string username, string channelName, bool enabled);
        public abstract ErrorCode OptInToBroadcasterLanguageChat(string username, string channelName, string language);
        public abstract ErrorCode SetLocalLanguage(string language);

        #endregion
    }
}
