﻿using System;
using System.Collections.Generic;

namespace Twitch.Chat
{
    public interface IChatChannelListener
    {
        void ChatChannelStateChangedCallback(string channelName, TTV_ChatChannelState state, ErrorCode ec);
        void ChatChannelInfoChangedCallback(string channelName, ChatChannelInfo info);
        void ChatChannelLocalUserChangedCallback(string channelName, ChatUserInfo userInfo);
        void ChatChannelUserChangeCallback(string channelName, ChatUserInfo[] joinList, ChatUserInfo[] leaveList, ChatUserInfo[] infoChangeList);
        void ChatChannelMessageCallback(string channelName, ChatMessage[] messageList);
        void ChatChannelClearCallback(string channelName, string username);
        void ChatChannelBadgeDataDownloadCallback(string channelName, ErrorCode ec);
        void ChatChannelHostTargetChangedCallback(string channelName, string targetChannel, int numViewers);
        void ChatChannelNoticeCallback(string channelName, string id, Dictionary<string, string> parameters);
        void ChatChannelSetBroadcasterLanguageCallback(string channelName, ErrorCode ec);
    }
}
