using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace Twitch
{
    public abstract class CoreApi
    {
        #region Singleton

        internal static CoreApi s_Instance = null;

        public static CoreApi Instance
        {
            get { return s_Instance; }
        }

        #endregion

        public CoreApi()
        {
            if (s_Instance == null)
            {
                s_Instance = this;
            }
        }

        #region API

        public abstract string ErrorToString(ErrorCode err);
        public abstract ErrorCode SetTraceLevel(MessageLevel traceLevel);
        public abstract ErrorCode SetTraceOutput(string outputFilePath);

        #endregion
    }
}
