﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

using SequenceId = System.UIntPtr; // To handle ulong size properly


namespace Twitch
{
    public class StandardCoreApi : CoreApi
    {
        #region Native Functions

        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_Core_SetTraceLevel")]
        internal static extern ErrorCode TTV_CSharp_Core_SetTraceLevel(MessageLevel traceLevel);
        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_Core_SetTraceOutput")]
        internal static extern ErrorCode TTV_CSharp_Core_SetTraceOutput([MarshalAs(UnmanagedType.LPWStr)] string outputFilePath);
        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_Core_ErrorToString")]
        internal static extern IntPtr TTV_CSharp_Core_ErrorToString(ErrorCode err);

        #endregion

        #region CoreApi Implementation

        public override ErrorCode SetTraceLevel(MessageLevel traceLevel)
        {
            return TTV_CSharp_Core_SetTraceLevel(traceLevel);
        }

        public override ErrorCode SetTraceOutput(string outputFilePath)
        {
            return TTV_CSharp_Core_SetTraceOutput(outputFilePath);
        }

        public unsafe override string ErrorToString(ErrorCode err)
        {
            string result = "Unknown error";

            IntPtr p = TTV_CSharp_Core_ErrorToString(err);
            if (p == IntPtr.Zero)
            {
                return result;
            }

            return MarshalUtil.StringFromBytes((byte*)p, int.MaxValue);
        }

        #endregion
    }
}
