﻿using System;
using System.Collections.Generic;

namespace Twitch
{
    public class FrameBuffer
    {
        protected byte[] m_Buffer = null;
        protected IntPtr m_Pointer = IntPtr.Zero;

        public uint Size
        {
            get { return (uint)m_Buffer.Length; }
        }

        public byte[] Buffer
        {
            get { return m_Buffer; }
        }

        public IntPtr Pointer
        {
            get { return m_Pointer; }
        }

        public FrameBuffer(uint size)
        {
            m_Buffer = new byte[size];
            m_Pointer = MemoryManager.PinObject(m_Buffer);

            MemoryManager.RegisterFrameBuffer(this);
        }

        public void Free()
        {
            if (m_Pointer != IntPtr.Zero)
            {
                MemoryManager.UnregisterFrameBuffer(this);

                MemoryManager.UnpinObject(m_Buffer);
                m_Buffer = null;
                m_Pointer = IntPtr.Zero;
            }
        }
    }
}
