﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace Twitch
{
    public abstract class Library
    {
        #region Singleton

        internal static Library s_Instance = null;

        public static Library Instance
        {
            get { return s_Instance; }
        }

        #endregion

        #region Members

        public Library()
        {
            if (s_Instance == null)
            {
                s_Instance = this;
            }
        }

        #endregion

        private bool sInitialized = false;
        private bool sBroadcasting = false;

        public bool Initialized
        {
            get { return sInitialized; }
        }

        public bool BroadcastInitialized
        {
            get { return sInitialized && sBroadcasting; }
        }

        public bool ChatInitialized
        {
            get { return sInitialized; }
        }
    
        public ErrorCode broadcastingLibraryInitialize(String clientId) 
        {
            if (sInitialized)
            {
                return ErrorCode.TTV_EC_ALREADY_INITIALIZED;
            }

            ErrorCode ec = BroadcastInitialize(clientId);
    
            if (Error.Succeeded(ec)) 
            {
                sBroadcasting = true;
                sInitialized = true;
            }

            return ec;
        }

        public ErrorCode broadcastingLibraryShutdown() 
        {
            if (!sInitialized || !sBroadcasting)
            {
                return ErrorCode.TTV_EC_NOT_INITIALIZED;
            }

            ErrorCode ec = BroadcastShutdown();

            if (Error.Succeeded(ec)) 
            {
                sInitialized = false;
            }

            return ec;
        }

        public ErrorCode chatLibraryInitialize() 
        {
            if (sInitialized)
            {
                return ErrorCode.TTV_EC_ALREADY_INITIALIZED;
            }

            ErrorCode ec = ChatInitialize();

            if (Error.Succeeded(ec)) 
            {
                sBroadcasting = false;
    			sInitialized = true;
            }

        
            return ec;
        }

        public ErrorCode chatLibraryShutdown() 
        {
            if (!sInitialized || sBroadcasting)
            {
                return ErrorCode.TTV_EC_NOT_INITIALIZED;
            }

            ErrorCode ec = ChatShutdown();

            if (Error.Succeeded(ec)) 
            {
			    sInitialized = false;
            }

            return ec;
        }

        protected abstract ErrorCode BroadcastInitialize(string clientId);
        protected abstract ErrorCode BroadcastShutdown();
        protected abstract ErrorCode ChatInitialize();
        protected abstract ErrorCode ChatShutdown();
    }
}
