﻿using System;
using System.Collections.Generic;

namespace Twitch
{
    class MarshalUtil
    {
        public unsafe static string StringFromBytes(byte* arr, int maxLen)
        {
            if (arr == null)
            {
                return string.Empty;
            }
            else
            {
                int len = Strlen(arr, maxLen);

                byte[] bytes = new byte[len];
                System.Runtime.InteropServices.Marshal.Copy(new IntPtr(arr), bytes, 0, len);

                return System.Text.Encoding.UTF8.GetString(bytes);
            }
        }

        public unsafe static void StringToBytes(string str, byte* arr, int maxLen)
        {
            byte[] bytes = System.Text.Encoding.UTF8.GetBytes(str);
            int len = Math.Min(maxLen, bytes.Length);

            System.Runtime.InteropServices.Marshal.Copy(bytes, 0, new IntPtr(arr), len);
            arr[maxLen-1] = (byte)'\0';
        }

        public unsafe static int Strlen(byte* arr, int maxLen)
        {
            int len = 0;
            for (; len < maxLen && arr[len] != '\0'; ++len) ;
            return len;
        }
    }
}
