﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace Twitch
{
    public class StandardLibrary : Library
    {
        #region Native Functions

        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_BroadcastLibrary_Initialize")]
        internal static extern ErrorCode TTV_CSharp_BroadcastLibrary_Initialize(string clientID);
        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_BroadcastLibrary_Shutdown")]
        internal static extern ErrorCode TTV_CSharp_BroadcastLibrary_Shutdown();

        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_ChatLibrary_Initialize")]
        internal static extern ErrorCode TTV_CSharp_ChatLibrary_Initialize();
        [DllImport("twitchsdk", CallingConvention = CallingConvention.Cdecl, EntryPoint = "TTV_CSharp_ChatLibrary_Shutdown")]
        internal static extern ErrorCode TTV_CSharp_ChatLibrary_Shutdown();

        #endregion

        protected override ErrorCode BroadcastInitialize(string clientId)
        {
            return TTV_CSharp_BroadcastLibrary_Initialize(clientId);
        }
        protected override ErrorCode BroadcastShutdown()
        {
            return TTV_CSharp_BroadcastLibrary_Shutdown();
        }

        protected override ErrorCode ChatInitialize()
        {
            return TTV_CSharp_ChatLibrary_Initialize();
        }
        protected override ErrorCode ChatShutdown()
        {
            return TTV_CSharp_ChatLibrary_Shutdown();
        }
    }
}
