﻿using System;
using System.Collections.Generic;


namespace Twitch.Test
{
    public class TestFrameGenerator
    {
        protected uint mHeight = 0;
        protected uint mWidth = 0;
        protected uint mColor1 = 0x000000FF;
        protected uint mColor2 = 0xFFFFFFFF;
        protected float mTime = 0;
        protected Random mRng = new Random();

        public TestFrameGenerator(uint width, uint height)
        {
            mWidth = width;
            mHeight = height;
        }
        
        public virtual void Generate(UIntPtr buffer)
        {
            uint size = mHeight * mWidth * 4;

            unsafe
            {
                uint c1 = mColor1;
                uint c2 = mColor2;
                byte* b1 = (byte*)&c1;
                byte* b2 = (byte*)&c2;

                float r = (float)b1[0] * (1 - mTime) + (float)b2[0] * mTime;
                float g = (float)b1[1] * (1 - mTime) + (float)b2[1] * mTime;
                float b = (float)b1[2] * (1 - mTime) + (float)b2[2] * mTime;

                uint clr = (uint)(((byte)r << 24) | ((byte)g << 16) | ((byte)b << 8) | 0xFF);

                uint* arr = (uint*)buffer.ToPointer();
                for (int i = 0; i < size/4; ++i)
                {
                    arr[i] = clr;
                }
            }

            mTime += 1.0f / 30.0f;

            if (mTime >= 1.0f)
            {
                mTime -= 1.0f;

                mColor1 = mColor2;
                mColor2 = (uint)mRng.Next();
            }
        }
    }
}
