/**
 * The vertex shader for rendering a textured quad in D3D11.  It is compiled offline with the shader compiler and 
 * the generated header file is compiled into the SDK project for use at runtime.
 */

cbuffer MatrixBuffer
{
    matrix mvpMatrix;
};

struct VertexInputType
{
	float4 posTex : POSITION;
};

struct PixelInputType
{
	float4 position : SV_POSITION;
	float2 texCoord : TEXCOORD0;
};


PixelInputType main(VertexInputType IN)
{
	PixelInputType OUT;

	float4 pos = float4(IN.posTex.x, IN.posTex.y, -2, 1);

	OUT.position = mul(pos, mvpMatrix);
	OUT.texCoord = IN.posTex.zw;

	return OUT;
}
