##Introduction
Growing the number of broadcasters is a strategic priority for Twitch, and the broadcasting SDK is the centerpiece of our efforts on this front. Game developers will be able to build streaming directly into their games by integrating the SDK and providing a simple UI for it. This will increase the number of people broadcasting a game due to several reasons:
* Currently a screen capture software (e.g. xSplit) is needed for streaming and a fair bit of effort is required to set up the software properly in order to generate a good quality stream. Having streaming built into the game makes it much easier to stream without the need to purchase and configure additional software. 

* Since the SDK will be fed the game's frame buffer directly without the need for screen capture, it will lower the minimum system requirements for streaming. Therefore, more people with lower end machines will be able to stream.

* By being part of the UI of the game, new people are introduced to streaming.

Having more people stream a game is not only beneficial to Twitch; it also benefits the game in several ways:
* Strongest step a publisher can take to build a Twitch community around their game

* A Twitch community creates authentic engaging user generated content that attracts new players and deepens the engagement of existing players.

* Adds a "back of the box" differentiating feature to the game

##SDK Overview
The Twitch SDK takes care of authentication, video and audio encoding, audio capture, and streaming to Twitch servers. The game needs to provide a simple UI for basic settings and user login; beyond that it just supplies its frame buffer to the SDK which takes care of the reset. Here is a list of the capabilities of the SDK:

* Performs authentication and obtains a stream key (does not support account creation)
* Allows setting a game and broadcast title
* Returns a list of available ingest servers to the game
* Calculates default bitrate based on resolution and frame rate and allows the game to override it
* Captures speaker and microphone audio, mixes, and encodes them (currently in MP3)
* Performs frame dropping if necessary and encodes the frames (currently in H.264)
* Muxes audio and video and streams over RTMP
* Allows sending metadata: Imagine the enhancements to viewing, video editing, and discovery this enables
* Allows setting trace level for debugging 
* Allows requesting of broadcast information, such as viewer number??!?!?

Currently the SDK is only available on PC, however, we plan on supporting Mac, iOS and other platforms in the future.

##Integration
One of our primary design goals for the SDK has been to make it as easy as possible to integrate into a game. In our experience most games have been able to do the integration in 2-5 days. The README file in conjunction with the comments in the API headers provide all the instructions needed to integrate the SDK.

https://github.com/twitchsdk/twitchsdk/blob/master/README.md  
https://github.com/twitchsdk/twitchsdk/blob/master/include/twitchsdk.h  
https://github.com/twitchsdk/twitchsdk/blob/master/include/twitchsdktypes.h  

We have a sample that shows the basic flow of using the API functions. We'll be providing more complete samples in the near future.

https://github.com/twitchsdk/twitchsdk/wiki/Basic-Sample  

####Submitting Frames
The game provides its frame buffer to the SDK by calling the TTV_SubmitVideoFrame() function. The SDK will call the callback function provided by the game when it's done with the frame data. It's important that the game doesn't delete/modify the buffer until the SDK calls the callback. The game must maintain exactly 3 buffers for its captured frames. The SDK can hold two frames at a given time: one being encoded and one 'waiting' frame) and it calls the game's callback to release the frame when either it's done encoding a frame or a new frame is submitted and thus overwrites the waiting frame. By maintaining 3 buffers (2 of which can be in use by the SDK) the game always has an available buffer to write to. If the game submits frames faster than the target frame rate, the SDK will perform frame dropping (by simply overwriting the frame that's waiting).

##Licensing
Twitch SDK is provided to game developers free of charge, subject to the terms of the Twitch SDK License Agreement (https://github.com/twitchsdk/twitchsdk/blob/master/licenses/Twitch%20SDK%20License%20Agreement.pdf)

There are two licensing aspects for the libraries used by the SDK: 
* Patent fees for H.264 and MP3: Twitch has signed agreements with MPEGLA (H.264) and Fraunhofer IIS and Thomson Licensing (MP3) and will be taking care of the payment of patent fees

* Licenses for encoders and other libraries used in the SDK: All the libraries used are free and/or open source software and pose no licensing concerns.

All licencing information can be found under the licenses folder: https://github.com/twitchsdk/twitchsdk/tree/master/licenses  

## Announcements

We've made very few SDK press releases, and request that you hold off on making any announcements until you can coordinate with our Marketing dept.  Please e-mail matt@justin.tv to coordinate press releases.  


##FAQ
####What resolutions does the SDK support?  
The SDK supports all resolutions up to 1920x1200, however please see the next question regarding bitrates if you want to use resolutions higher than 720p. The width and height must be multiples of 16. It's strongly recommended that the width be a multiple of 32 (otherwise a performance penalty is incurred).  

####Does the SDK do scaling of frames?
No, the game needs to supply frames at the same resolution as the desired output video resolution. The reason is that we believe the game can do the scaling of frames much more efficiently than the SDK.  

####How is the default bitrate calculated?
To achieve a good quality in the final encoded video we target 0.1 bits per pixel in the encoded frames. We calculate the default bitrate based on this target. For example with a resolution of 1280x720 at 30 FPS we get:
1280 * 720 * 30 * 0.1 = 2764 Kbps  
Therefore to maintain a similar quality at 1080p you'll need a bitrate of over 6 Mpbs. This is obviously not realistic for most people and the SDK currently limits the maximum bitrate you can set to 3500 Kbps. This means that in most cases a higher resolution will actually result in a lower quality (especially in fast motion scenes).

####Can we modify the SDK's source code?
Twitch gives developers access to the SDK source for ease of debugging, and for testing purposes. Our terms of service explicitly forbid shipping a modified SDK. The SDK team will respond to e-mails, github issues, and pull requests within a business day, so that publishers should only need to modify the SDK in test branches. A modified SDK is much harder for us to support, and will make it difficult for publishers to perform updates.